import urllib2
import mimetools, mimetypes
import os, stat
from cStringIO import StringIO

class Callable:
    def __init__(self, anycallable):
        self.__call__ = anycallable

# Controls how sequences are uncoded. If true, elements may be given multiple values by
#  assigning a sequence.
doseq = 1

class MultipartPostHandler(urllib2.BaseHandler):
    handler_order = urllib2.HTTPHandler.handler_order - 10 # needs to run first

    def http_request(self, request):
        data = request.get_data()
        if data is not None and type(data) != str:
            v_files = []
            v_vars = []
            try:
                 for(key, value) in data.items():
                     if type(value) == file:
                         v_files.append((key, value))
                     else:
                         v_vars.append((key, value))
            except TypeError:
                systype, value, traceback = sys.exc_info()
                raise TypeError, "not a valid non-string sequence or mapping object", traceback

            if len(v_files) == 0:
                data = urllib.urlencode(v_vars, doseq)
            else:
                boundary, data = self.multipart_encode(v_vars, v_files)

                contenttype = 'multipart/form-data; boundary=%s' % boundary
                if(request.has_header('Content-Type')
                   and request.get_header('Content-Type').find('multipart/form-data') != 0):
                    print "Replacing %s with %s" % (request.get_header('content-type'), 'multipart/form-data')
                request.add_unredirected_header('Content-Type', contenttype)

            request.add_data(data)
        
        return request

    def multipart_encode(vars, files, boundary = None, buf = None):
        if boundary is None:
            boundary = mimetools.choose_boundary()
        if buf is None:
            buf = StringIO()
        for(key, value) in vars:
            buf.write('--%s\r\n' % boundary)
            buf.write('Content-Disposition: form-data; name="%s"' % key)
            buf.write('\r\n\r\n' + value + '\r\n')
        for(key, fd) in files:
            file_size = os.fstat(fd.fileno())[stat.ST_SIZE]
            filename = fd.name.split('/')[-1]
            contenttype = mimetypes.guess_type(filename)[0] or 'application/octet-stream'
            buf.write('--%s\r\n' % boundary)
            buf.write('Content-Disposition: form-data; name="%s"; filename="%s"\r\n' % (key, filename))
            buf.write('Content-Type: %s\r\n' % contenttype)
            # buffer += 'Content-Length: %s\r\n' % file_size
            fd.seek(0)
            buf.write('\r\n' + fd.read() + '\r\n')
        buf.write('--' + boundary + '--\r\n\r\n')
        buf = buf.getvalue()
        return boundary, buf
    multipart_encode = Callable(multipart_encode)

    https_request = http_request
def main():
    import sys

	  # please replace the filename below with the name of your own tab-delimited input network file (in human ENSEMBL gene format)
    your_input_file = "example.txt"
    
    opener = urllib2.build_opener(MultipartPostHandler)
    
    params = { "upFile" : "yes",
    					 "file" : open("C:/xampp/htdocs/enrichnet/"+your_input_file, "rb") }
  
    response = opener.open('http://elephant.embl.de/enrichnet/fileupload.php', params).read()
    
    
    # the parameters to run the network-based enrichment analysis (replace them with your genes and pathways of interest)
    genes = ''
    idtype = ''
    pathdb = ''
    graph = 'own'
    params = { "genes" : genes, "idtype" : idtype, "pathdb" : pathdb, "graph" : graph }
    
    url = 'http://elephant.embl.de/enrichnet/index.php'
    params = urllib.urlencode({ 'genes':genes, 'idtype':idtype, 'pathdb':pathdb, 'graph':graph})
    
    response = urllib2.urlopen(url+'?'+params).read()
    
    print "If your job submission succeeded, the hyperlink to retrieve the results will appear below:"
    print response

if __name__=="__main__":
    main()
